<?php

/* --------------------------------------------------------------
   ContentStatus.inc.php 2019-04-12
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2019 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

/**
 * Class ContentStatus
 *
 * This class represents the content active status
 *
 * @category   System
 * @package    Content
 */
class ContentStatus implements ContentStatusInterface
{
    /**
     * Content active status
     *
     * @var bool
     */
    protected $active;
    
    
    /**
     * ContentStatus constructor
     *
     * @param bool $active Content active status
     */
    public function __construct(bool $active)
    {
        $this->active = $active;
    }
    
    
    /**
     * Return whether the content is active
     *
     * @return bool
     */
    public function isActive(): bool
    {
        return $this->active;
    }
}